--[[---------------------------------------------------------------------------
	Chocolatier Two Logo Editor
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------

local ts = (gSim.logo.ts - 10) / (100-10)

local w = 700
local h = 500
local logoW = 350
local logoH = 200
local dY = 28

local items = {}
for item in LItem:KnownRecipes() do
	local total = item.inventory + item.sold
	if total > 0 then table.insert(items, item.name.."_big") end
end

if not gSim.logo.tfo then gSim.logo.tfo = 1 end

MakeDialog
{
	name="logoedit",
	Frame
	{
		x=kCenter,y=kCenter,w=w,h=h,
		LogoEditor
		{
			x=0,y=0,w=kMax,h=kMax,
			logo=gSim.logo,
			logox=5,logoy=295,
			itemsAllowed=items,

			SetStyle(sliderStyle),
			
			AppendStyle { font=dialogFont },
			Text { x=logoW,y=55,w=350,h=20, label="logo_background" },
			Slider { x=logoW+20,y=75,w=310,name="background", value=0 },
			
			Window { x=56,y=0, fit=true,
				Text { x=0,y=0,w=450,h=20, label="logo_name", font=dialogFont },
				Bitmap { x=0,y=20, image="control/company_entry_field",
					TextEdit { x=18,y=5,w=418,h=21, name="nameedit", label=(gSim.logo.t or "BLAHBLAH"), length=25, ignore=kIgnoreBadSignChars }, },
				TextButton { x=460,y=20, label="ok", scale=30/ui.devButtonH, default=true,
					command = function()
						logoChanged = true
						SetLogoText(GetLabel("nameedit"))
					end
				},
			},
			Window { x=logoW,y=110, fit=true,
				AppendStyle { font=dialogFont },
				Text { x=0,y=0,w=350,h=20, label="logo_textmods" },

				SetStyle(sliderStyle),
--				TextButton { x=30,y=25, scale=.5, type=kRadio, label="logo_outline", command=function() ToggleOutline() end },
				Button { x=30,y=12, scale=.5, type=kToggle, name="outline", graphics=CheckButtonGraphics, command=function() ToggleOutline() end },
				Text { x=30+30,y=17,w=ui.devButtonW-32,h=32, label="logo_outline", flags=kVAlignCenter+kHAlignLeft },

--				TextButton { x=130,y=25, scale=.5, type=kRadio, label="logo_italic", command=function() ToggleItalic() end },
				Button { x=130,y=12, scale=.5, type=kToggle, name="italic", graphics=CheckButtonGraphics, command=function() ToggleItalic() end },
				Text { x=130+30,y=17,w=ui.devButtonW-32,h=32, label="logo_italic", flags=kVAlignCenter+kHAlignLeft },

--				TextButton { x=230,y=25, scale=.5, type=kRadio, label="logo_bold", command=function() ToggleBold() end },
				Button { x=230,y=12, scale=.5, type=kToggle, name="bold", graphics=CheckButtonGraphics, command=function() ToggleBold() end },
				Text { x=230+30,y=17,w=ui.devButtonW-32,h=32, label="logo_bold", flags=kVAlignCenter+kHAlignLeft },

				TextButton { x=30,y=50, scale=.5, label="logo_left", command=function() SetLeftJustify() end },
				TextButton { x=130,y=50, scale=.5, label="logo_center", command=function() SetCenterJustify() end },
				TextButton { x=230,y=50, scale=.5, label="logo_right", command=function() SetRightJustify() end },

				AppendStyle { font=smallDialogFont },
				Text { x=0,y=80,w=78,h=dY, label="logo_font", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=80,w=250,name="font", value=0 },
				Text { x=0,y=110,w=78,h=dY, label="logo_size", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=110,w=250,name="textsize", value=ts },
				Text { x=0,y=140,w=78,h=dY, label="logo_alpha", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=140,w=250,name="textalpha", value=gSim.logo.ta/1000 },

				Text { x=0,y=170,w=78,h=dY, label="logo_colorH", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=170,w=250,name="tColorH", value=gSim.logo.tch/1000,
					railtop="control/empty",railmid="control/colorbar_v",railbot="control/empty",},
				Text { x=0,y=200,w=78,h=dY, label="logo_colorS", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=200,w=250,name="tColorS", value=gSim.logo.tcs/1000 },
				Text { x=0,y=230,w=78,h=dY, label="logo_colorV", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=230,w=250,name="tColorV", value=gSim.logo.tcv/1000 },

				Text { x=0,y=260,w=78,h=dY, label="logo_halign", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=260,w=250,name="textx", value=gSim.logo.tx/1000 },
				Text { x=0,y=290,w=78,h=dY, label="logo_valign", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=290,w=250,name="texty", value=gSim.logo.ty/1000 },
			},
			
			Window { x=0,y=55, fit=true,
				AppendStyle { font=dialogFont },
				Text { x=0,y=0,w=350,h=20, label="logo_graphic" },
				Slider { x=20,y=20,w=310,name="graphic", value=0 },
				Text { x=0,y=55,w=350,h=20, label="logo_mods" },
				AppendStyle { font=smallDialogFont },
				Text { x=0,y=75,w=78,h=dY, label="logo_size", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=75,w=250,name="logoscale", value=gSim.logo.ls/1000 },
				Text { x=0,y=105,w=78,h=dY, label="logo_alpha", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=105,w=250,name="logoalpha", value=gSim.logo.la/1000 },
				Text { x=0,y=135,w=78,h=dY, label="logo_rotate", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=135,w=250,name="logorotate", value=gSim.logo.lr/1000 },
				Text { x=0,y=165,w=78,h=dY, label="logo_halign", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=165,w=250,name="logox", value=gSim.logo.lx/1000 },
				Text { x=0,y=195,w=78,h=dY, label="logo_valign", flags=kVAlignCenter+kHAlignRight },
				Slider { x=80,y=195,w=250,name="logoy", value=gSim.logo.ly/1000 },
			},
			
			SetStyle(standardStyle),
			TextButton { x=355,y=kMax-45, label="logo_basic", scale=1,
				command = function()
					local logo = GetLogoString()
					if logo then
						logo = loadstring(logo)
						if type(logo) == "function" then logo = logo() end
						if logo then gSim.logo = logo end
					end
					PopModal("logoedit")
					DisplayDialog { "ui/logoedit_basic.lua" }
				end },

			TextButton { x=kMax-ui.devButtonW+10,y=kMax-45, name="ok", label="done", scale=1,
				command=function()
					local logo = GetLogoString()
					if logo then
						logo = loadstring(logo)
						if type(logo) == "function" then logo = logo() end
						if logo then gSim.logo = logo end
					end
					-- FIRSTPEEK: AdvancedLogoClose, time-stamp, weeks
					if fpWrite then fpWrite { "AdvancedLogoClose", gSim.weeks } end
					CloseWindow()
--					SwapToModal("ui/portview.lua")
--					StopPulsing()
				end },
		},
	},
}

if gSim.logo.tfo and (gSim.logo.tfo > 0) then
	SetButtonToggleState("outline", true)
end

if gSim.logo.tfi and (gSim.logo.tfi > 0) then
	SetButtonToggleState("italic", true)
end

if gSim.logo.tfb and (gSim.logo.tfb > 0) then
	SetButtonToggleState("bold", true)
end
